# First Contentful Paint Changes in M86

## Changes in Chrome 86
In Chrome 86, some small changes were made to First Contentful Paint to bring
its implementation in line with the [specification](https://www.w3.org/TR/paint-timing/).

The changes are:
 * Video elements now trigger FCP when painted. [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2276244).
 * Only SVG elements with content now trigger FCP. Previously empty SVG paints triggered SVG. [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2285532).
 * WebGL2 canvases now trigger FCP when painted. [Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2348694).

## How does this affect a site's metrics?

This change affects a small set of sites:
 * Sites with a first contentful paint which is only a video element without a `poster` attribute will have an earlier FCP time.
 * Sites with a first contentful paint which is only an empty SVG element will have a later FCP time.
 * Sites with a first contentful paint which is only a WebGL canvas will have an earlier FCP time.

We do not see an impact from this change in our overall metrics, so we believe
the effect on most sites will be minimal.

## When were users affected?

Most users were updated to Chrome 86 the week of October 5, 2020.
