% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sxp.R
\name{sxp}
\alias{sxp}
\title{Inspect an object}
\usage{
sxp(x, expand = character(), max_depth = 5L)
}
\arguments{
\item{x}{Object to inspect}

\item{expand}{Optionally, expand components of the true that are usually
suppressed. Use:
\itemize{
\item "character" to show underlying entries in the global string pool.
\item "environment" to show binding components without any side effects (e.g. promises or active bindings).
\item "altrep" to show the underlying data.
\item "call" to show the full AST (but \code{\link[=ast]{ast()}} is usually superior)
\item "bytecode" to show generated bytecode.
}}

\item{max_depth}{Maximum depth to recurse. Use \code{max_depth = Inf} (with care!)
to recurse as deeply as possible. Skipped elements will be shown as \code{...}.`}
}
\description{
\code{sxp(x)} is similar to \code{.Internal(inspect(x))}, recursing into the C data
structures underlying any R object. The main difference is the output is a
little more compact, it recurses fully, and avoids getting stuck in infinite
loops by using a depth-first search. It also returns a list that you can
compute with, and carefully uses colour to highlight the most important
details.
}
\details{
The name \code{sxp} comes from \code{SEXP}, the name of the C data structure that
underlies all R objects.
}
\examples{
x <- list(
  TRUE,
  1L,
  runif(100),
  "3"
)
sxp(x)

# Expand "character" to see underlying CHARSXP entries in the global
# string pool
x <- c("banana", "banana", "apple", "banana")
sxp(x)
sxp(x, expand = "character")

# Expand altrep to see underlying data
x <- 1:10
sxp(x)
sxp(x, expand = "altrep")

# Expand environments to see promise expressions without forcing
e <- new.env(parent = emptyenv())
delayedAssign("x", 1 + 1, assign.env = e)

sxp(e)
sxp(e, expand = "environment")
}
\seealso{
Other object inspectors: 
\code{\link{ast}()},
\code{\link{ref}()},
\code{\link{src}()}
}
\concept{object inspectors}
