// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ModelsBridge models bridge
//
// swagger:model models.Bridge
type ModelsBridge struct {

	// Any authentication method needed for connect to the bridge, `none`
	// otherwise.
	Auth string `json:"auth,omitempty"`

	// Bucket is a "bucket" tag that connotes a resource group that a user may or may not
	// have access to. An empty bucket string implies that it is open access
	Bucket string `json:"bucket,omitempty"`

	// An experimental bridge flags any bridge that, for whatever reason,
	// is not deemed stable. The expectation is that clients have to opt-in to
	// experimental bridges (and gateways too).
	Experimental bool `json:"experimental,omitempty"`

	// Healthy indicates whether this bridge can be used normally.
	Healthy bool `json:"healthy,omitempty"`

	// Host is a unique identifier for the bridge.
	Host string `json:"host,omitempty"`

	// IP6Addr is the IPv6 address
	Ip6Addr string `json:"ip6_addr,omitempty"`

	// IPAddr is the IPv4 address
	IPAddr string `json:"ip_addr,omitempty"`

	// LastSeenMillis is a unix time in milliseconds representing the last time we received a heartbeat update from this bridge
	LastSeenMillis int64 `json:"lastSeenMillis,omitempty"`

	// Load is the fractional load - but for now menshen agent is not measuring
	// load in the bridges.
	Load float64 `json:"load,omitempty"`

	// Location refers to the location to which this bridge points to
	Location string `json:"location,omitempty"`

	// Options contain the map of options that will be passed to the client. It usually
	// contains authentication credentials.
	Options map[string]interface{} `json:"options,omitempty"`

	// Overloaded should be set to true if the fractional load is above threshold.
	Overloaded bool `json:"overloaded,omitempty"`

	// For some protocols (like hopping) port is undefined.
	Port int64 `json:"port,omitempty"`

	// TCP, UDP or KCP. This was called "protocol" before.
	Transport string `json:"transport,omitempty"`

	// Type of bridge.
	Type string `json:"type,omitempty"`
}

// Validate validates this models bridge
func (m *ModelsBridge) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this models bridge based on context it is used
func (m *ModelsBridge) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ModelsBridge) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsBridge) UnmarshalBinary(b []byte) error {
	var res ModelsBridge
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
