% This LilyPond file was generated by Rosegarden 25.06
\include "nederlands.ly"
\version "2.18.0"
\header {
    composer = "Antonio Vivaldi (1675-1741)"
    opus = "Op. 44, 11"
    subtitle = "C major"
    title = "Concerto for Flautino"
    tagline = "Created using Rosegarden 25.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 3/4
    \skip 2.*155 
}
globalTempo = {
    \override Score.MetronomeMark.transparent = ##t
    \tempo 4 = 120  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn.force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering.staff-padding = #'()
        \context StaffGroup = "1" <<

            \context Staff = "track 1, flautino" << 
                \set Staff.instrumentName = \markup { \center-column { "flautino " } }
                \set Staff.midiInstrument = "Flute"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 0.0" {
                    % Segment: 
                    \override Voice.TextScript.padding = #2.0
                    \override MultiMeasureRest.expand-limit = 1
                    \once \override Staff.TimeSignature.style = #'numbered 
                    \time 3/4
                    
                    \clef "treble^8"
                    g''' 4 ^\markup { \bold \large "Allegro" } g''' g'''  |
                    g''' 4 r8 e''' 16 [ f''' ] g''' 8 [ a''' 16 b''' ]  |
                    c'''' 4 g''' g'''  |
                    g''' 4 r8 e''' 16 [ f''' ] g''' 8 [ a''' 16 b''' ]  |
%% 5
                    c'''' 4 c''' r  |
                    g''' 8 [ f''' 16 g''' ] e''' 8 [ d''' 16 e''' ] c''' 8 [ b'' 16 c''' ]  |
                    a''' 8 [ a'' ] c''' [ a'' ] c''' [ f''' ]  |
                    a''' 8 [ g''' 16 a''' ] fis''' 8 [ e''' 16 fis''' ] d''' 8 [ c''' 16 d''' ]  |
                    b''' 8 [ b'' ] d''' [ b'' ] d''' [ g''' ]  |
%% 10
                    b''' 8 [ a''' 16 b''' ] gis''' 8 [ fis''' 16 gis''' ] e''' 8 [ d''' 16 e''' ]  |
                    c'''' 8 [ c''' ] e''' [ c''' ] e''' [ a''' ]  |
                    c'''' 8 [ b''' 16 c'''' ] a''' 8 [ g''' 16 a''' ] f''' 8 [ e''' 16 f''' ]  |
                    f''' 4. b'' 16 [ c''' d''' e''' ] f''' [ g''' ]  |
                    a''' 4 ^\( g''' f''' \)  |
%% 15
                    e''' 8 [ e''' 16 f''' ] g''' 8 [ c'''' ] g''' [ e''' ]  |
                    c''' 8 [ e''' 16 f''' ] g''' 8 [ c'''' ] g''' [ e''' ]  |
                    c''' 8 [ c'''' ] e''' [ c'''' ] d''' [ b''' ]  |
                    c'''' 4 r r  |
                    e''' 16 [ g''' f''' g''' ] e''' [ g''' f''' g''' ] d''' [ g''' f''' g''' ]  |
%% 20
                    c''' 16 [ g''' f''' g''' ] e''' [ g''' f''' g''' ] d''' [ g''' f''' g''' ]  |
                    c''' 16 [ c'''' b''' c'''' ] g''' [ c'''' b''' c'''' ] e''' [ c'''' b''' c'''' ]  |
                    c''' 16 [ c'''' b''' c'''' ] g''' [ c'''' b''' c'''' ] e''' [ c'''' b''' c'''' ]  |
                    c''' 16 [ e'''' d'''' e'''' ] c'''' [ e'''' d'''' e'''' ] g''' [ e'''' d'''' e'''' ]  |
                    c''' 16 [ e'''' d'''' e'''' ] c'''' [ e'''' d'''' e'''' ] g''' [ e'''' d'''' e'''' ]  |
%% 25
                    c''' 16 [ b'' c''' d''' ] e''' [ d''' e''' f''' ] g''' [ f''' g''' a''' ]  |
                    bes''' 4 ^\( a''' gis''' \)  |
                    d''' 16 [ c''' d''' e''' ] fis''' [ e''' fis''' g'''? ] a''' [ g''' a''' b'''? ]  |
                    c'''' 4 ^\( b''' ais''' \)  |
                    e''' 16 [ d''' e''' fis''' ] gis''' [ fis''' gis''' a''' ] b''' [ a''' b''' c'''' ]  |
%% 30
                    d'''' 4 ^\( c'''' b''' \)  |
                    c'''' 2 -\trill r4  |
                    c'''' 16 [ e'''' d'''' e'''' ] c'''' [ e'''' d'''' e'''' ] a''' [ e'''' d'''' e'''' ]  |
                    f''' 16 [ d'''' c'''' d'''' ] b''' [ d'''' c'''' d'''' ] g''' [ d'''' c'''' d'''' ]  |
                    e''' 16 [ c'''' b''' c'''' ] a''' [ c'''' b''' c'''' ] f''' [ c'''' b''' c'''' ]  |
%% 35
                    d''' 16 [ b''' a''' b''' ] gis''' [ b''' a''' b''' ] e''' [ b''' a''' b''' ]  |
                    c''' 16 [ d''' c''' a'' ] d''' [ e''' d''' b'' ] e''' [ f''' e''' c''' ]  |
                    f''' 16 [ g''' f''' d''' ] gis''' [ a''' gis''' e''' ] a''' [ b''' a''' fis''' ]  |
                    b''' 16 [ c'''' b''' gis''' ] c'''' [ d'''' c'''' a''' ] d'''' [ e'''' d'''' b''' ]  |
                    c'''' 4. -\trill b''' 16 [ a''' b''' 8 -\trill ] a''' 16 [ gis''' ]  |
%% 40
                    a''' 16 [ a''' gis''' a''' ] e''' [ c'''' b''' c'''' ] e''' [ e'''' d'''' e'''' ]  |
                    e''' 16 [ a''' gis''' a''' ] c''' [ a''' gis''' a''' ] b'' [ gis''' fis''' gis''' ]  |
                    a''' 4 e''' e'''  |
                    e''' 4 r8 c''' 16 [ d''' ] e''' 8 [ fis''' 16 gis''' ]  |
                    a''' 4 e''' e'''  |
%% 45
                    e''' 4 r8 c''' 16 [ d''' ] e''' 8 [ fis''' 16 gis''' ]  |
                    a''' 4 a'' r  |
                    c''' 8 [ c''' 16 d''' ] e''' 8 [ a''' ] e''' [ c''' ]  |
                    a'' 8 [ c''' 16 d''' ] e''' 8 [ a''' ] e''' [ c''' ]  |
                    a'' 8 [ a''' ] c''' [ a''' ] b'' [ gis''' ]  |
%% 50
                    a''' 16 [ e''' c''' a'' ] a'' [ c''' e''' a''' ] a'' [ c''' e''' a''' ]  |
                    a''' 16 [ e''' c''' a'' ] a'' [ c''' e''' a''' ] a'' [ c''' e''' a''' ]  |
                    b''' 16 [ gis''' d''' b'' ] b'' [ d''' gis''' b''' ] b'' [ d''' gis''' b''' ]  |
                    b''' 16 [ gis''' d''' b'' ] b'' [ d''' gis''' b''' ] b'' [ d''' gis''' b''' ]  |
                    a''' 16 [ e''' c''' a'' ] a'' [ c''' e''' a''' ] a'' [ c''' e''' a''' ]  |
%% 55
                    c'''' 16 [ a''' e''' a'' ] a'' [ e''' a''' c'''' ] a'' [ e''' a''' e'''' ]  |
                    e'''' 16 [ c'''' a''' a'' ] a'' [ a''' c'''' e'''' ] a'' [ a''' c'''' e'''' ]  |
                    d'''' 16 [ a''' fis''' a'' ] a'' [ fis''' a''' d'''' ] a'' [ fis''' a''' d'''' ]  |
                    d'''' 16 [ b''' g''' g'' ] g'' [ g''' b''' d'''' ] g'' [ g''' b''' d'''' ]  |
                    d'''' 16 [ b''' f''' g'' ] g'' [ f''' b''' d'''' ] g'' [ f''' b''' d'''' ]  |
%% 60
                    c'''' 16 [ g''' e''' g'' ] g'' [ e''' g''' c'''' ] g'' [ e''' g''' c'''' ]  |
                    bes''' 16 [ g''' e''' g'' ] g'' [ e''' g''' bes''' ] g'' [ e''' g''' bes''' ]  |
                    a''' 16 [ f''' c''' f'' ] f'' [ c''' f''' a''' ] f'' [ c''' f''' a''' ]  |
                    bes''' 16 [ g''' e''' c''' ] c''' [ e''' g''' bes''' ] c''' [ e''' g''' bes''' ]  |
                    c'''' 16 [ a''' f''' c''' ] c''' [ f''' a''' c'''' ] c''' [ f''' a''' c'''' ]  |
%% 65
                    d'''' 16 [ bes''' g''' c''' ] c''' [ g''' bes''' d'''' ] c''' [ g''' bes''' d'''' ]  |
                    e'''' 16 [ c'''' g''' c''' ] c''' [ g''' c'''' e'''' ] c''' [ g''' c'''' e'''' ]  |
                    f'''' 4 f''' r8 \times 2/3 { f''' 16 ^\( [ g''' a''' \) ] }  |
                    d''' 8 \times 2/3 { d''' 16 ^\( [ e''' f''' \) ] } bes'' 8 \times 2/3 { bes'' 16 ^\( [ c''' d''' \) ] } g'' 8 \times 2/3 { g'' 16 _\( [ a'' bes'' \) ] }  |
                    e''' 8 \times 2/3 { e''' 16 ^\( [ f''' g''' \) ] } c''' 8 \times 2/3 { c''' 16 ^\( [ d''' e''' \) ] } a'' 8 \times 2/3 { a'' 16 _\( [ b'' c''' \) ] }  |
%% 70
                    f''' 8 \times 2/3 { f''' 16 ^\( [ g''' a''' \) ] } d''' 8 \times 2/3 { d''' 16 ^\( [ e''' f''' \) ] } bes'' 8 \times 2/3 { bes'' 16 ^\( [ c''' d''' \) ] }  |
                    g''' 8 \times 2/3 { g''' 16 ^\( [ a''' bes''' \) ] } a''' 8 \times 2/3 { a''' 16 ^\( [ bes''' c'''' \) ] } bes''' 8 \times 2/3 { bes''' 16 ^\( [ c'''' d'''' \) ] }  |
                    c'''' 16 [ bes''' ] \times 2/3 { a''' ^\( [ g''' f''' \) ] } g''' 2 -\trill  |
                    f''' 4 c'''' c''''  |
                    c'''' 4 r8 f''' 16 [ g''' ] a''' 8 [ a''' 16 bes''' ]  |
%% 75
                    c'''' 4 c'''' c''''  |
                    c'''' 4 r8 f''' 16 [ g''' ] a''' 8 [ a''' 16 bes''' ]  |
                    c'''' 8 [ bes''' 16 c'''' ] a''' 8 [ g''' 16 a''' ] f''' 8 [ e''' 16 f''' ]  |
                    d''' 8 [ c''' 16 d''' ] bes'' 8 [ a'' 16 bes'' ] g'' 8 [ f'' 16 g'' ]  |
                    e'' 8 [ e''' ] g''' [ bes''' ] g''' [ e''' ]  |
%% 80
                    f''' 8 [ a'' ] g'' [ f''' ] g'' [ e''' ]  |
                    f''' 16 [ e''' f''' g''' ] f''' [ e''' f''' g''' ] f''' [ g''' a''' bes''' ]  |
                    c'''' 4 c'''' 2 -\trill  |
                    g''' 16 [ fis''' g''' a''' ] g''' [ fis''' g''' a''' ] g''' [ a''' bes''' c'''' ]  |
                    d'''' 4 d'''' 2 -\trill  |
%% 85
                    a''' 16 [ gis''' a''' b''' ] a''' [ gis''' a''' b''' ] a''' [ b''' c'''' d'''' ]  |
                    e'''' 4 e'''' 2 -\trill  |
                    c'''' 16 [ e'''' c'''' a''' ] c'''' [ e'''' c'''' a''' ] c'''' [ e'''' c'''' a''' ]  |
                    f''' 16 [ a''' f''' d''' ] f''' [ a''' f''' d''' ] f''' [ a''' f''' d''' ]  |
                    b''' 16 [ d'''' b''' g''' ] b''' [ d'''' b''' g''' ] b''' [ d'''' b''' g''' ]  |
%% 90
                    e''' 16 [ g''' e''' c''' ] e''' [ g''' e''' c''' ] e''' [ g''' e''' c''' ]  |
                    a''' 16 [ c'''' a''' e''' ] a''' [ c'''' a''' e''' ] a''' [ c'''' a''' e''' ]  |
                    dis''' 16 [ b'' cis''' dis''' ] e''' [ fis''' g''' a''' ] b''' 8 r  |
                    dis''' 16 [ fis''' dis''' b'' ] dis''' [ fis''' dis''' b'' ] dis''' [ fis''' dis''' b'' ]  |
                    e''' 16 [ g''' e''' b'' ] e''' [ g''' e''' b'' ] e''' [ g''' e''' b'' ]  |
%% 95
                    fis''' 16 [ a''' fis''' b'' ] fis''' [ a''' fis''' b'' ] fis''' [ a''' fis''' b'' ]  |
                    g''' 16 [ b''' g''' b'' ] g''' [ b''' g''' b'' ] g''' [ b''' g''' b'' ]  |
                    a''' 16 [ c'''' a''' b'' ] a''' [ c'''' a''' b'' ] a''' [ c'''' a''' b'' ]  |
                    g''' 8 -\trill [ fis''' 16 e''' ] a''' 8 -\trill [ g''' 16 fis''' ] b''' 8 -\trill [ a''' 16 g''' ]  |
                    c'''' 8 -\trill [ b''' 16 a''' ] dis'''' 4 e''''  |
%% 100
                    g''' 8 -\trill [ fis''' 16 e''' ] dis'''' 4 e''''  |
                    g''' 16 [ b''' g''' e''' ] g''' [ b''' g''' e''' ] fis''' [ b''' fis''' dis''' ]  |
                    e''' 4 g''' 8 [ fis''' 16 g''' ] e''' 8 [ dis''' 16 e''' ]  |
                    c'''' 8 [ c''' ] e''' [ c''' ] e''' [ a''' ]  |
                    c'''' 8 [ b''' 16 c'''' ] a''' 8 [ g''' 16 a''' ] fis''' 8 [ e''' 16 fis''' ]  |
%% 105
                    d'''' 8 [ d''' ] fis''' [ d''' ] fis''' [ b''' ]  |
                    d'''' 8 [ c'''' 16 d'''' ] b''' 8 [ a''' 16 b''' ] g''' 8 [ fis''' 16 g''' ]  |
                    e'''' 8 [ e''' ] g''' [ e''' ] g''' [ c'''' ]  |
                    e'''' 8 [ d'''' 16 e'''' ] c'''' 8 [ b''' 16 c'''' ] a''' 8 [ gis''' 16 a''' ]  |
                    a''' 4 r8 dis''' 16 [ e''' ] fis''' [ g''' a''' b''' ]  |
%% 110
                    c'''' 4 ^\( b''' a''' \)  |
                    g''' 8 [ g''' 16 a''' ] b''' 8 [ g''' ] a''' [ fis''' ]  |
                    e''' 8 [ b''' ] e'''' [ e''' ] g'' [ g''' ]  |
                    a''' 8 [ c'''' ] dis''' [ b'' ] fis'' [ fis''' ]  |
                    gis''' 8 [ b''' ] e'''' [ e''' ] gis'' [ d'''' ]  |
%% 115
                    cis'''' 8 [ e'''' ] a''' [ e'''' ] a'' [ e'''' ]  |
                    fis''' 8 [ a''' ] d'''' [ d''' ] fis'' [ c'''' ]  |
                    b''' 8 [ d'''' ] g''' [ d'''' ] g'' [ d'''' ]  |
                    e''' 8 [ g''' ] c'''' [ e''' ] g'' [ c'''' ]  |
                    a''' 8 [ c'''' ] f''' [ c'''' ] f'' [ c'''' ]  |
%% 120
                    f''' 8 [ b''' ] d'''' [ f''' ] g'' [ f''' ]  |
                    e''' 8 [ c''' ] e''' [ g''' ] c'''' r  |
                    c''' 16 [ e''' g''' c'''' ] c'''' [ g''' e''' c''' ] c''' [ e''' g''' c'''' ]  |
                    c'''' 16 [ g''' e''' c''' ] c''' [ e''' g''' c'''' ] c'''' [ g''' e''' c''' ]  |
                    b'' 16 [ d''' g''' b''' ] b''' [ g''' d''' b'' ] b'' [ g''' b''' d'''' ]  |
%% 125
                    d'''' 16 [ b''' g''' g'' ] g'' [ b''' d'''' f'''' ] f'''' [ d'''' b''' g''' ]  |
                    bes'' 16 [ e''' g''' bes''' ] bes''' [ g''' e''' bes'' ] bes'' [ e''' g''' bes''' ]  |
                    bes''' 16 [ g''' e''' bes'' ] bes'' [ e''' g''' bes''' ] bes''' [ g''' e''' bes'' ]  |
                    a'' 16 [ c''' f''' a''' ] a''' [ f''' c''' a'' ] a'' [ f''' a''' c'''' ]  |
                    c'''' 16 [ a''' f''' a'' ] a'' [ a''' c'''' f'''' ] f'''' [ c'''' a''' a'' ]  |
%% 130
                    g'' 16 [ b'' d''' g''' ] g''' [ d''' b'' g'' ] g'' [ d''' g''' b''' ]  |
                    b''' 16 [ g''' d''' g'' ] g'' [ g''' b''' d'''' ] d'''' [ b''' g''' g'' ]  |
                    g'' 16 [ d'''' e'''' f'''' ] g'' [ c'''' d'''' e'''' ] g'' [ b''' c'''' d'''' ]  |
                    g'' 16 [ a''' b''' c'''' ] g'' [ g''' a''' b''' ] g'' [ f''' g''' a''' ]  |
                    g'' 16 [ d'''' e'''' f'''' ] g'' [ c'''' d'''' e'''' ] g'' [ b''' c'''' d'''' ]  |
%% 135
                    g'' 16 [ a''' b''' c'''' ] g'' [ g''' a''' b''' ] g'' [ f''' g''' a''' ]  |
                    g'' 4 -\trill r16 g'' [ a'' b'' ] c''' [ d''' e''' f''' ]  |
                    g''' 16 [ b'' c''' d''' ] e''' [ f''' g''' a''' ] b''' [ d''' e''' f''' ]  |
                    g''' 16 [ a''' b''' c'''' ] d'''' [ f''' g''' a''' ] b''' [ c'''' d'''' e'''' ]  |
                    f'''' 16 [ e'''' d'''' e'''' ] e'''' [ d'''' c'''' d'''' ] d'''' [ c'''' b''' c'''' ]  |
%% 140
                    c'''' 16 [ b''' a''' b''' ] b''' [ a''' g''' a''' ] a''' [ g''' fis''' g''' ]  |
                    g''' 16 [ d''' g''' b''' ] g''' [ d''' g''' b''' ] g''' [ d''' g''' b''' ]  |
                    c'''' 8 [ d'''' ] d'''' 2 -\trill  |
                    c'''' 8 [ f''' 16 g''' ] e''' 8 [ d''' 16 e''' ] c''' 8 [ b'' 16 c''' ]  |
                    a''' 8 [ a'' ] c''' [ a'' ] c''' [ f''' ]  |
%% 145
                    a''' 8 [ g''' 16 a''' ] fis''' 8 [ e''' 16 fis''' ] d''' 8 [ c''' 16 d''' ]  |
                    b''' 8 [ b'' ] d''' [ b'' ] d''' [ g''' ]  |
                    b''' 8 [ a''' 16 b''' ] gis''' 8 [ fis''' 16 gis''' ] e''' 8 [ d''' 16 e''' ]  |
                    c'''' 8 [ c''' ] e''' [ c''' ] e''' [ a''' ]  |
                    c'''' 8 [ b''' 16 c'''' ] a''' 8 [ g''' 16 a''' ] f''' 8 [ e''' 16 f''' ]  |
%% 150
                    f''' 4 r8 b'' 16 [ c''' ] d''' [ e''' f''' g''' ]  |
                    a''' 4 ^\( g''' f''' \)  |
                    e''' 8 [ e''' 16 f''' ] g''' 8 [ c'''' ] g''' [ e''' ]  |
                    c''' 8 [ e''' 16 f''' ] g''' 8 [ c'''' ] g''' [ e''' ]  |
                    c''' 8 [ c'''' ] e''' [ c'''' ] d''' [ b''' ]  |
%% 155
                    c'''' 4 r r 
                    \bar "|."
                } % Voice

                % End of segment 

                % End voice 0
            >> % Staff ends
            \context GrandStaff = "1" <<

                \context Staff = "track 2, violino 1" << 
                    \set Staff.instrumentName = \markup { \center-column { "violino 1 " } }
                    \set Staff.midiInstrument = "Violin"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 1.0" {
                        % Segment: 
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 3/4
                        
                        \clef "treble"
                        g'' 4 g'' g''  |
                        g'' 4 r8 e'' 16 [ f'' ] g'' 8 [ a'' 16 b'' ]  |
                        c''' 4 g'' g''  |
                        g'' 4 r8 e'' 16 [ f'' ] g'' 8 [ a'' 16 b'' ]  |
%% 5
                        c''' 4 c'' r  |
                        g'' 8 [ f'' 16 g'' ] e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ]  |
                        a'' 8 [ a' ] c'' [ a' ] c'' [ f'' ]  |
                        a'' 8 [ g'' 16 a'' ] fis'' 8 [ e'' 16 fis'' ] d'' 8 [ c'' 16 d'' ]  |
                        b'' 8 [ b' ] d'' [ b' ] d'' [ g'' ]  |
%% 10
                        b'' 8 [ a'' 16 b'' ] gis'' 8 [ fis'' 16 gis'' ] e'' 8 [ d'' 16 e'' ]  |
                        c''' 8 [ c'' ] e'' [ c'' ] e'' [ a'' ]  |
                        c''' 8 [ b'' 16 c''' ] a'' 8 [ g'' 16 a'' ] f'' 8 [ e'' 16 f'' ]  |
                        f'' 4. b' 16 [ c'' d'' e'' ] f'' [ g'' ]  |
                        a'' 4 ^\( g'' f'' \)  |
%% 15
                        e'' 8 [ e'' 16 f'' ] g'' 8 [ c''' ] g'' [ e'' ]  |
                        c'' 8 [ e'' 16 f'' ] g'' 8 [ c''' ] g'' [ e'' ]  |
                        c'' 8 [ c''' ] e'' [ c''' ] d'' [ b'' ]  |
                        c''' 4 r r  |
                        g'' 4 r r  |
%% 20
                        g'' 4 r r  |
                        g'' 4 r r  |
                        g'' 4 r r  |
                        g'' 4 r r  |
                        g'' 4 r r  |
%% 25
                        g'' 4 g'' g''  |
                        e'' 4 r r  |
                        a'' 4 a'' a''  |
                        fis'' 4 r r  |
                        b'' 4 b'' b''  |
%% 30
                        gis'' 4 r r  |
                        a'' 8 [ a' ] c'' [ a' ] e'' [ c'' ]  |
                        R2.*10  |
                        e'' 4 e'' e''  |
                        e'' 4 r8 c'' 16 [ d'' ] e'' 8 [ fis'' 16 gis'' ]  |
                        a'' 4 e'' e''  |
%% 45
                        e'' 4 r8 c'' 16 [ d'' ] e'' 8 [ fis'' 16 gis'' ]  |
                        a'' 4 a' r  |
                        c'' 8 [ c'' 16 d'' ] e'' 8 [ a'' ] e'' [ c'' ]  |
                        a' 8 [ c'' 16 d'' ] e'' 8 [ a'' ] e'' [ c'' ]  |
                        a' 8 [ a'' ] c'' [ a'' ] b' [ gis'' ]  |
%% 50
                        a'' 4 r r  |
                        c'' 8 [ e'' ] a'' [ c'' ] e'' [ a'' ]  |
                        r8 gis'' b'' [ d'' ] gis'' [ b'' ]  |
                        r8 gis'' b'' [ d'' ] gis'' [ b'' ]  |
                        r8 e'' a'' [ c'' ] e'' [ a'' ]  |
%% 55
                        r8 e'' a'' [ c'' ] e'' [ e''' ]  |
                        r8 e'' a'' [ c'' ] e'' [ a'' ]  |
                        r8 d'' a'' [ d'' ] fis'' [ d''' ]  |
                        r8 d'' g'' [ d'' ] g'' [ d''' ]  |
                        r8 d'' f'' [ d'' ] f'' [ d''' ]  |
%% 60
                        r8 c'' e'' [ c'' ] e'' [ c''' ]  |
                        r8 c'' e'' [ c'' ] e'' [ bes'' ]  |
                        r8 f'' a'' [ c'' ] f'' [ a'' ]  |
                        r8 g'' bes'' [ e'' ] g'' [ bes'' ]  |
                        r8 c'' f'' [ c'' ] f'' [ c''' ]  |
%% 65
                        r8 c'' e'' [ c'' ] e'' [ g'' ]  |
                        r8 c'' e'' [ c'' ] e'' [ g'' ]  |
                        a'' 4 r r  |
                        R2.*5  |
                        c''' 4 c''' c'''  |
                        c''' 4 r8 f'' 16 [ g'' ] a'' 8 [ a'' 16 bes'' ]  |
%% 75
                        c''' 4 c''' c'''  |
                        c''' 4 r8 f'' 16 [ g'' ] a'' 8 [ a'' 16 bes'' ]  |
                        c''' 8 [ bes'' 16 c''' ] a'' 8 [ g'' 16 a'' ] f'' 8 [ e'' 16 f'' ]  |
                        d'' 8 [ c'' 16 d'' ] bes' 8 [ a' 16 bes' ] g' 8 [ f' 16 g' ]  |
                        e' 8 [ e'' ] g'' [ bes'' ] g'' [ e'' ]  |
%% 80
                        f'' 8 [ a' ] g' [ f'' ] g' [ e'' ]  |
                        f'' 4 r r  |
                        R2.*11  |
                        fis'' 4 fis'' fis''  |
                        g'' 4 g'' g''  |
%% 95
                        a'' 4 a'' a''  |
                        b'' 4 b'' b''  |
                        a'' 4 a'' a''  |
                        g'' 4 r r  |
                        R2.*3  |
                        b'' 8 [ a'' 16 b'' ] g'' 8 [ fis'' 16 g'' ] e'' 8 [ dis'' 16 e'' ]  |
                        c''' 8 [ c'' ] e'' [ c'' ] e'' [ a'' ]  |
                        c''' 8 [ b'' 16 c''' ] a'' 8 [ g'' 16 a'' ] fis'' 8 [ e'' 16 fis'' ]  |
%% 105
                        d''' 8 [ d'' ] fis'' [ d'' ] fis'' [ b'' ]  |
                        d''' 8 [ c''' 16 d''' ] b'' 8 [ a'' 16 b'' ] g'' 8 [ fis'' 16 g'' ]  |
                        e''' 8 [ e'' ] g'' [ e'' ] g'' [ c''' ]  |
                        e''' 8 [ d''' 16 e''' ] c''' 8 [ b'' 16 c''' ] a'' 8 [ gis'' 16 a'' ]  |
                        a'' 4 r8 dis'' 16 [ e'' ] fis'' [ g'' a'' b'' ]  |
%% 110
                        c''' 4 ^\( b'' a'' \)  |
                        g'' 8 [ g'' 16 a'' ] b'' 8 [ g'' ] a'' [ fis'' ]  |
                        e'' 4 r r  |
                        R2.*9  |
                        e'' 4 e'' e''  |
                        e'' 4 e'' e''  |
                        d'' 4 d'' d''  |
%% 125
                        d'' 4 d'' d''  |
                        e'' 4 e'' e''  |
                        e'' 4 e'' e''  |
                        c'' 4 c'' c''  |
                        a'' 4 a'' a''  |
%% 130
                        d'' 4 d'' d''  |
                        d'' 4 d'' d''  |
                        f'' 4 e'' d''  |
                        c'' 4 b' a'  |
                        f'' 4 e'' d''  |
%% 135
                        c'' 4 b' a'  |
                        b' 2. _~  |
                        b' 2. _~  |
                        b' 2. _~  |
                        f'' 4 e'' d''  |
%% 140
                        c'' 4 b' a'  |
                        b' 4 d'' d''  |
                        e'' 8 [ f'' ] d'' 2  |
                        e'' 8 [ f'' 16 g'' ] e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ]  |
                        a'' 8 [ a' ] c'' [ a' ] c'' [ f'' ]  |
%% 145
                        a'' 8 [ g'' 16 a'' ] fis'' 8 [ e'' 16 fis'' ] d'' 8 [ c'' 16 d'' ]  |
                        b'' 8 [ b' ] d'' [ b' ] d'' [ g'' ]  |
                        b'' 8 [ a'' 16 b'' ] gis'' 8 [ fis'' 16 gis'' ] e'' 8 [ d'' 16 e'' ]  |
                        c''' 8 [ c'' ] e'' [ c'' ] e'' [ a'' ]  |
                        c''' 8 [ b'' 16 c''' ] a'' 8 [ g'' 16 a'' ] f'' 8 [ e'' 16 f'' ]  |
%% 150
                        f'' 4 r8 b' 16 [ c'' ] d'' [ e'' f'' g'' ]  |
                        a'' 4 ^\( g'' f'' \)  |
                        e'' 8 [ e'' 16 f'' ] g'' 8 [ c''' ] g'' [ e'' ]  |
                        c'' 8 [ e'' 16 f'' ] g'' 8 [ c''' ] g'' [ e'' ]  |
                        c'' 8 [ c''' ] e'' [ c''' ] d'' [ b'' ]  |
%% 155
                        c''' 4 r r 
                        \bar "|."
                    } % Voice

                    % End of segment 

                    % End voice 0
                >> % Staff ends

                \context Staff = "track 3, violino 2" << 
                    \set Staff.instrumentName = \markup { \center-column { "violino 2 " } }
                    \set Staff.midiInstrument = "String Ensemble 2"
                    \set Score.skipBars = ##t
                    \set Staff.printKeyCancellation = ##f
                    \new Voice \global
                    \new Voice \globalTempo
                    \set Staff.autoBeaming = ##f % turns off all autobeaming

                    \context Voice = "voice 2.0" {
                        % Segment:  
                        \override Voice.TextScript.padding = #2.0
                        \override MultiMeasureRest.expand-limit = 1
                        \once \override Staff.TimeSignature.style = #'numbered 
                        \time 3/4
                        
                        \clef "treble"
                        R2.  |
                        g'' 4 g'' g''  |
                        g'' 4 r8 e'' 16 [ f'' ] g'' 8 [ a'' 16 b'' ]  |
                        c''' 4 g'' g''  |
%% 5
                        g'' 4 r8 e'' 16 [ f'' ] g'' 8 [ a'' 16 b'' ]  |
                        c''' 4 c'' r  |
                        c'' 8 [ b' 16 c'' ] a' 8 [ g' 16 a' ] f' 8 [ e' 16 f' ]  |
                        d'' 8 [ d' ] fis' [ d' ] fis' [ a' ]  |
                        d'' 8 [ c'' 16 d'' ] b' 8 [ a' 16 b' ] g' 8 [ fis' 16 g' ]  |
%% 10
                        e'' 8 [ e' ] gis' [ e' ] gis' [ b' ]  |
                        e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ] a' 8 [ gis' 16 a' ]  |
                        f'' 8 [ f' ] a' [ f' ] a' [ c'' ]  |
                        d'' 4. g' 16 [ a' b' c'' ] d'' [ e'' ]  |
                        f'' 4 ^\( e'' d'' \)  |
%% 15
                        c'' 8 [ c'' 16 d'' ] e'' 8 [ g'' ] e'' [ c'' ]  |
                        g' 8 [ c'' 16 d'' ] e'' 8 [ g'' ] e'' [ c'' ]  |
                        g' 8 [ e'' ] c'' [ e'' ] b' [ d'' ]  |
                        e'' 4 r r  |
                        e'' 4 r r  |
%% 20
                        e'' 4 r r  |
                        e'' 4 r r  |
                        e'' 4 r r  |
                        e'' 4 r r  |
                        e'' 4 r r  |
%% 25
                        e'' 4 e'' e''  |
                        c'' 4 r r  |
                        fis'' 4 fis'' fis''  |
                        d'' 4 r r  |
                        gis'' 4 gis'' gis''  |
%% 30
                        e'' 4 r r  |
                        e'' 8 [ e' ] a' [ e' ] c'' [ a' ]  |
                        R2.*11  |
                        e'' 4 e'' e''  |
                        e'' 4 r8 c'' 16 [ d'' ] e'' 8 [ fis'' 16 gis'' ]  |
%% 45
                        a'' 4 e'' e''  |
                        e'' 4 r8 c'' 16 [ d'' ] e'' 8 [ fis'' 16 gis'' ]  |
                        a'' 8 [ a' 16 b' ] c'' 8 [ e'' ] c'' [ a' ]  |
                        e' 8 [ a' 16 b' ] c'' 8 [ e'' ] c'' [ a' ]  |
                        e' 8 [ c'' ] a' [ c'' ] gis' [ b' ]  |
%% 50
                        c'' 4 r r  |
                        a' 8 [ c'' ] e'' [ a' ] c'' [ e'' ]  |
                        r8 e'' gis'' [ b' ] e'' [ gis'' ]  |
                        r8 e'' gis'' [ b' ] e'' [ gis'' ]  |
                        r8 c'' e'' [ a' ] c'' [ e'' ]  |
%% 55
                        r8 c'' e'' [ a' ] c'' [ a'' ]  |
                        r8 c'' e'' [ a' ] c'' [ e'' ]  |
                        r8 a' d'' [ a' ] d'' [ a'' ]  |
                        r8 b' d'' [ b' ] d'' [ b'' ]  |
                        r8 b' d'' [ b' ] d'' [ b'' ]  |
%% 60
                        r8 a' c'' [ a' ] c'' [ g'' ]  |
                        r8 g' c'' [ g' ] c'' [ g'' ]  |
                        r8 a' f'' [ a' ] c'' [ f'' ]  |
                        r8 e'' g'' [ c'' ] e'' [ g'' ]  |
                        r8 a' c'' [ a' ] c'' [ a'' ]  |
%% 65
                        r8 g' c'' [ g' ] c'' [ e'' ]  |
                        r8 g' c'' [ g' ] c'' [ e'' ]  |
                        c'' 4 r r  |
                        R2.*6  |
                        c''' 4 c''' c'''  |
%% 75
                        c''' 4 r8 f'' 16 [ g'' ] a'' 8 [ a'' 16 bes'' ]  |
                        c''' 4 c''' c'''  |
                        a'' 8 [ g'' 16 a'' ] f'' 8 [ e'' 16 f'' ] d'' 8 [ c'' 16 d'' ]  |
                        f'' 8 [ e'' 16 f'' ] d'' 8 [ c'' 16 d'' ] b' 8 [ a' 16 b' ]  |
                        g' 8 [ c'' ] e'' [ g'' ] e'' [ c'' ]  |
%% 80
                        a' 8 [ f'' ] g' [ f'' ] g' [ e'' ]  |
                        f'' 4 r r  |
                        R2.*11  |
                        dis'' 4 dis'' dis''  |
                        e'' 4 e'' e''  |
%% 95
                        fis'' 4 fis'' fis''  |
                        g'' 4 g'' g''  |
                        fis'' 4 fis'' fis''  |
                        e'' 4 r r  |
                        R2.*4  |
                        e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ] a' 8 [ gis' 16 a' ]  |
                        fis'' 8 [ fis' ] a' [ fis' ] a' [ c'' ]  |
%% 105
                        fis'' 8 [ e'' 16 fis'' ] d'' 8 [ c'' 16 d'' ] b' 8 [ a' 16 b' ]  |
                        g'' 8 [ g' ] b' [ g' ] b' [ d'' ]  |
                        g'' 8 [ fis'' 16 g'' ] e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ]  |
                        a'' 8 [ a' ] c'' [ a' ] c'' [ e'' ]  |
                        fis'' 4 r8 b' 16 [ cis'' ] dis'' [ e'' fis'' g'' ]  |
%% 110
                        a'' 4 ^\( g'' fis'' \)  |
                        e'' 8 [ e'' 16 fis'' ] g'' 8 [ e'' ] fis'' [ dis'' ]  |
                        e'' 4 r r  |
                        R2.*9  |
                        g' 4 g' g'  |
                        g' 4 g' g'  |
                        b' 4 b' b'  |
%% 125
                        b' 4 b' b'  |
                        g' 4 g' g'  |
                        g' 4 g' g'  |
                        a' 4 a' a'  |
                        c'' 4 c'' c''  |
%% 130
                        b' 4 b' b'  |
                        b' 4 b' b'  |
                        d'' 4 c'' b'  |
                        a' 4 g' f'  |
                        d'' 4 c'' b'  |
%% 135
                        a' 4 g' f'  |
                        d' 2. _~  |
                        d' 2. _~  |
                        d' 2. _~  |
                        d'' 4 c'' b'  |
%% 140
                        a' 4 g' fis'  |
                        g' 4 b' b'  |
                        g' 8 [ a' ] b' 2  |
                        c'' 4 c'' r  |
                        c'' 8 [ b' 16 c'' ] a' 8 [ g' 16 a' ] f' 8 [ e' 16 f' ]  |
%% 145
                        d'' 8 [ d' ] fis' [ d' ] fis' [ a' ]  |
                        d'' 8 [ c'' 16 d'' ] b' 8 [ a' 16 b' ] g' 8 [ fis' 16 g' ]  |
                        e'' 8 [ e' ] gis' [ e' ] gis' [ b' ]  |
                        e'' 8 [ d'' 16 e'' ] c'' 8 [ b' 16 c'' ] a' 8 [ g' 16 a' ]  |
                        f'' 8 [ f' ] a' [ f' ] a' [ c'' ]  |
%% 150
                        d'' 4 r8 g' 16 [ a' ] b' [ c'' d'' e'' ]  |
                        f'' 4 ^\( e'' d'' \)  |
                        c'' 8 [ c'' 16 d'' ] e'' 8 [ g'' ] e'' [ c'' ]  |
                        g' 8 [ c'' 16 d'' ] e'' 8 [ g'' ] e'' [ c'' ]  |
                        g' 8 [ e'' ] c'' [ e'' ] b' [ d'' ]  |
%% 155
                        e'' 4 r r 
                        \bar "|."
                    } % Voice

                    % End of segment  

                    % End voice 0
                >> % Staff ends
            >> % GrandStaff (final) 1

            \context Staff = "track 4, viola" << 
                \set Staff.instrumentName = \markup { \center-column { "viola " } }
                \set Staff.midiInstrument = "Viola"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 3.0" {
                    % Segment:  
                    \override Voice.TextScript.padding = #2.0
                    \override MultiMeasureRest.expand-limit = 1
                    \once \override Staff.TimeSignature.style = #'numbered 
                    \time 3/4
                    
                    \clef "alto"
                    e' 8 [ f' ] g' [ a' ] g' [ f' ]  |
                    e' 8 [ f' ] g' [ a' ] g' [ f' ]  |
                    e' 8 [ f' ] g' [ a' ] g' [ f' ]  |
                    e' 8 [ f' ] g' [ a' ] g' [ f' ]  |
%% 5
                    e' 8 [ f' ] g' [ a' ] g' [ f' ]  |
                    e' 4 f' g'  |
                    a 4 b c'  |
                    fis 4 g a  |
                    b 4 c' d'  |
%% 10
                    gis 4 a b  |
                    c' 4 d' e'  |
                    a 4 b c'  |
                    b 8 [ a' 16 g' ] f' 8 [ e' ] d' [ c' ]  |
                    b 2.  |
%% 15
                    g 8 [ g' ] c'' [ e'' ] c'' [ g' ]  |
                    e' 8 [ g' ] c'' [ e'' ] c'' [ g' ]  |
                    e' 8 [ g' ] g' [ g' ] g' [ g' ]  |
                    g' 4 r r  |
                    c'' 4 r r  |
%% 20
                    c'' 4 r r  |
                    c'' 4 r r  |
                    c'' 4 r r  |
                    c'' 4 r r  |
                    c'' 4 r r  |
%% 25
                    c' 4 c' c'  |
                    g' 4 r r  |
                    d' 4 d' d'  |
                    a' 4 r r  |
                    e' 4 e' e'  |
%% 30
                    b' 4 r r  |
                    c'' 8 [ c' ] e' [ c' ] a' [ e' ]  |
                    R2.*10  |
                    c' 8 [ d' ] e' [ f' ] e' [ d' ]  |
                    c' 8 [ d' ] e' [ f' ] e' [ d' ]  |
                    c' 8 [ d' ] e' [ f' ] e' [ d' ]  |
%% 45
                    c' 8 [ d' ] e' [ f' ] e' [ d' ]  |
                    c' 8 [ d' ] e' [ f' ] e' [ d' ]  |
                    c' 8 [ e' ] a' [ c'' ] a' [ e' ]  |
                    c' 8 [ e' ] a' [ c'' ] a' [ e' ]  |
                    c' 8 [ e' ] e' [ e' ] e' [ e' ]  |
%% 50
                    e' 4 r r  |
                    a' 4 a' a'  |
                    e' 4 e' e'  |
                    e' 4 e' e'  |
                    a' 4 a' a'  |
%% 55
                    a' 4 a' a'  |
                    a' 4 a' a'  |
                    fis' 4 fis' fis'  |
                    g' 4 g' g'  |
                    g' 4 g' g'  |
%% 60
                    c' 4 c' c'  |
                    c' 4 c' c'  |
                    f' 4 f' f'  |
                    c' 4 c' c'  |
                    c' 4 c' c'  |
%% 65
                    c' 4 c' c'  |
                    c' 4 c' c'  |
                    f' 4 r r  |
                    R2.*5  |
                    a' 8 [ bes' ] c'' [ d'' ] c'' [ bes' ]  |
                    a' 8 [ bes' ] c'' [ d'' ] c'' [ bes' ]  |
%% 75
                    a' 8 [ bes' ] c'' [ d'' ] c'' [ bes' ]  |
                    a' 8 [ bes' ] c'' [ d'' ] c'' 4  |
                    c'' 4 a' a'  |
                    bes' 4 d' d'  |
                    e' 8 [ g' ] c'' [ e' ] c'' [ c' ]  |
%% 80
                    c' 4 c' c'  |
                    a 4 r r  |
                    R2.*11  |
                    b 2. _~  |
                    b 2. _~  |
%% 95
                    b 2. _~  |
                    b 2. _~  |
                    b 2.  |
                    e' 4 r r  |
                    R2.*3  |
                    g' 4 a' b'  |
                    c' 4 d' e'  |
                    a 4 b c'  |
%% 105
                    d' 4 e' fis'  |
                    b 4 c' d'  |
                    e' 4 fis' g'  |
                    c' 4 d' e'  |
                    dis' 8 [ c'' 16 b' ] a' 8 [ g' ] fis' [ e' ]  |
%% 110
                    dis' 2.  |
                    b 8 [ b' ] b' [ b' ] b' [ b' ]  |
                    g' 4 r r  |
                    R2.*9  |
                    c' 4 c' c'  |
                    c' 4 c' c'  |
                    g 4 g g  |
%% 125
                    g 4 g g  |
                    c' 4 c' c'  |
                    c' 4 c' c'  |
                    f' 4 f' f'  |
                    f' 4 f' f'  |
%% 130
                    g 4 g g  |
                    g 4 g g  |
                    g 4 g g  |
                    g 4 g g  |
                    g 4 g g  |
%% 135
                    g 4 g g  |
                    g 2. _~  |
                    g 2. _~  |
                    g 2. _~  |
                    g 2. _~  |
%% 140
                    g 2. _~  |
                    g 4 g g  |
                    c' 8 [ f' ] g' 4 g  |
                    c' 4 f' g'  |
                    a 4 b c'  |
%% 145
                    fis 4 g a  |
                    b 4 c' d'  |
                    gis 4 a b  |
                    c' 4 d' e'  |
                    a 4 b c'  |
%% 150
                    b 8 [ a' 16 g' ] f' 8 [ e' ] d' [ c' ]  |
                    b 2.  |
                    g 8 [ g' ] c'' [ e'' ] c'' [ g' ]  |
                    e' 8 [ g' ] c'' [ e'' ] c'' [ g' ]  |
                    e' 8 [ g' ] g' [ g' ] g' [ g' ]  |
%% 155
                    g' 4 r r 
                    \bar "|."
                } % Voice

                % End of segment  

                % End voice 0
            >> % Staff ends

            \context Staff = "track 5, basso" << 
                \set Staff.instrumentName = \markup { \center-column { "basso " } }
                \set Staff.midiInstrument = "Contrabass"
                \set Score.skipBars = ##t
                \set Staff.printKeyCancellation = ##f
                \new Voice \global
                \new Voice \globalTempo
                \set Staff.autoBeaming = ##f % turns off all autobeaming

                \context Voice = "voice 4.0" {
                    % Segment: 
                    \override Voice.TextScript.padding = #2.0
                    \override MultiMeasureRest.expand-limit = 1
                    \once \override Staff.TimeSignature.style = #'numbered 
                    \time 3/4
                    
                    \clef "bass"
                    c 8 [ d ] e [ f ] e [ d ]  |
                    c 8 [ d ] e [ f ] e [ d ]  |
                    c 8 [ d ] e [ f ] e [ d ]  |
                    c 8 [ d ] e [ f ] e [ d ]  |
%% 5
                    c 8 [ d ] e [ f ] e [ d ]  |
                    c 4 d e  |
                    f 4 g a  |
                    d 4 e fis  |
                    g 4 a b  |
%% 10
                    e 4 fis aes  |
                    a 4 b c'  |
                    f 4 g a  |
                    g 8 [ f 16 e ] d 8 [ c ] b, [ a, ]  |
                    g, 2.  |
%% 15
                    c 8 [ c' ] c [ c' ] c [ c' ]  |
                    c 8 [ c' ] c [ c' ] c [ c' ]  |
                    c 8 [ c' ] c [ c' ] g, [ g ]  |
                    c 4 r r  |
                    c 4 r r  |
%% 20
                    c 4 r r  |
                    c 4 r r  |
                    c 4 r r  |
                    c 4 r r  |
                    c 4 r r  |
%% 25
                    c 4 c c  |
                    c 4 r r  |
                    d 4 d d  |
                    d 4 r r  |
                    e 4 e e  |
%% 30
                    e 4 r r  |
                    a, 4 a, a,  |
                    a, 4 a a,  |
                    d 4 g g,  |
                    c 4 f f,  |
%% 35
                    b, 4 e e,  |
                    a, 4 b, c  |
                    d 4 e fis  |
                    aes 4 a b  |
                    a 8 [ aes ] a [ a, ] e' [ e ]  |
%% 40
                    a, 4 a, a,  |
                    a, 4 e e,  |
                    a, 8 [ b, ] c [ d ] c [ b, ]  |
                    a, 8 [ b, ] c [ d ] c [ b, ]  |
                    a, 8 [ b, ] c [ d ] c [ b, ]  |
%% 45
                    a, 8 [ b, ] c [ d ] c [ b, ]  |
                    a, 8 [ b, ] c [ d ] c [ b, ]  |
                    a, 8 [ a ] a, [ a ] a, [ a ]  |
                    a, 8 [ a ] a, [ a ] a, [ a ]  |
                    a, 8 [ a ] a, [ a ] e, [ e ]  |
%% 50
                    a, 4 r r  |
                    R2.*16  |
                    f 8 [ e ] f [ g ] a [ f ]  |
                    b 8 r g r e r  |
                    c' 8 r a r f r  |
%% 70
                    d' 8 r bes r g r  |
                    e 8 r f r g r  |
                    a 8 [ f ] c' 4 c  |
                    f 8 [ g ] a [ bes ] a [ g ]  |
                    f 8 [ g ] a [ bes ] a [ g ]  |
%% 75
                    f 8 [ g ] a [ bes ] a [ g ]  |
                    f 8 [ g ] a [ bes ] a [ g ]  |
                    f 4 f f  |
                    bes 4 bes, b,  |
                    c 4 c c  |
%% 80
                    f 4 c' c  |
                    f 4 r r  |
                    e 4 d c  |
                    R2.  |
                    f 4 e d  |
%% 85
                    R2.  |
                    aes 4 fis e  |
                    a 4 a a  |
                    d' 4 d' d'  |
                    g 4 g g  |
%% 90
                    c' 4 c' c'  |
                    c' 4 c' c'  |
                    b 4 b, b,  |
                    R2.*5  |
                    e 4 fis g  |
                    a 4 b g  |
%% 100
                    e 4 b g  |
                    e 4 b b,  |
                    e 4 fis g  |
                    a 4 b c'  |
                    fis 4 g a  |
%% 105
                    b 4 c' d'  |
                    g 4 a b  |
                    c' 4 d' e'  |
                    a 4 b c'  |
                    b 8 [ a 16 g ] fis 8 [ e ] ees [ cis ]  |
%% 110
                    b, 2.  |
                    e 8 [ e ] e' [ e ] b [ b, ]  |
                    e 4 g e  |
                    fis 4 b, ees  |
                    e 4 aes e  |
%% 115
                    a 4 cis' cis  |
                    d 4 fis d  |
                    e 4 b b,  |
                    c 4 e c  |
                    f 4 a a,  |
%% 120
                    d 4 b, g,  |
                    c 4 c' g  |
                    R2.*21  |
                    c 4 d e  |
                    f 4 g a  |
%% 145
                    d 4 e fis  |
                    g 4 a b  |
                    e 4 fis aes  |
                    a 4 b c'  |
                    fis 4 g a  |
%% 150
                    g 8 [ fis 16 e ] d 8 [ c ] b, [ a, ]  |
                    g, 2.  |
                    c 8 [ c' ] c [ c' ] c [ c' ]  |
                    c 8 [ c' ] c [ c' ] c [ c' ]  |
                    c 8 [ c' ] c [ c' ] g, [ g ]  |
%% 155
                    c 4 r r 
                    \bar "|."
                } % Voice

                % End of segment 

                % End voice 0
            >> % Staff ends
        >> % StaffGroup 1

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
