# 2022-06-21 Triage Log

A pretty busy week for performance, with quite a few PRs landing with
significant improvements to specific benchmarks. Overall the week was positive,
with many benchmarks improving at least a little. No significant changes in
memory usage this week.

Triage done by **@simulacrum**.
Revision range: [edab34ab2abbafc16a78daedf71dbacd2eb0b7bf..abace0a1f17986d89aedf610819deab2b4afee56](https://perf.rust-lang.org/?start=edab34ab2abbafc16a78daedf71dbacd2eb0b7bf&end=abace0a1f17986d89aedf610819deab2b4afee56&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.5% | 6     |
| Regressions 😿 <br /> (secondary) | 2.9% | 14.7% | 37    |
| Improvements 🎉 <br /> (primary) | -1.9% | -19.4% | 89    |
| Improvements 🎉 <br /> (secondary) | -8.4% | -91.4% | 38    |
| All 😿🎉 (primary) | -1.8% | -19.4% | 95    |

5 Regressions, 6 Improvements, 3 Mixed; 1 of them in rollups
54 artifact comparisons made in total

#### Regressions

BTreeMap: Support custom allocators (v1.5) [#98103](https://github.com/rust-lang/rust/pull/98103)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5bc82c0b944dc6c8ed12372b4f79d1a8e3fb0cbd&end=1b9daa69640970e7858b7c8e1c9f72c604985e11&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.7% | 3.0% | 2     |
| Regressions 😿 <br /> (secondary) | 1.6% | 2.1% | 6     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 1.7% | 3.0% | 2     |

This regression is largely fixed by [#98178](https://github.com/rust-lang/rust/pull/98178).

Improve the tuple and unit trait docs [#97842](https://github.com/rust-lang/rust/pull/97842)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d40f24e956a698e47a209541031c4045acc5a684&end=6ec3993ef4a4eb72bc20477fe9a4d92acd53f2c6&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.6% | 2     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.4% | 3     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.4% | 0.6% | 2     |

Slight regressions to small number of doc benchmarks, likely due to slightly
more work during generation (std's docs changed).

Fix `SourceScope` for `if let` bindings. [#97931](https://github.com/rust-lang/rust/pull/97931)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=17c6bde14eabdd61c35505ed6834ee9196c2fdc9&end=9a0b7749665d925d8f533756149deba74f2db88b&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.5% | 4     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.3% | 1     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.4% | 0.5% | 4     |

Regression is pretty small and only one primary benchmark is affected (regex),
and only incremental scenarios there. Likely not enough to worry about.

Obligation forest tweaks [#97674](https://github.com/rust-lang/rust/pull/97674)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4104596251818f4f588051c7a8172ca9f5a195bf&end=1d6010816c37186e2bee316709f0c0197c427513&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.8% | 0.9% | 2     |
| Regressions 😿 <br /> (secondary) | 1.8% | 2.4% | 7     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 1     |
| All 😿🎉 (primary) | 0.8% | 0.9% | 2     |

keccak is the primary affected benchmark, and is known to be very sensitive to
changes to the obligation forest code. See some analysis in this
[comment](https://github.com/rust-lang/rust/pull/97674#issuecomment-1160914976)
following up on the results from the merge perf run.

Rollup of 4 pull requests [#98307](https://github.com/rust-lang/rust/pull/98307)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5750a6aa2777382bf421b726f234da23f990a953&end=08871139915b95ec868aff807f224f78d00f4311&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.3% | 2     |
| Regressions 😿 <br /> (secondary) | 0.7% | 0.8% | 6     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.4% | 1     |
| All 😿🎉 (primary) | 0.3% | 0.3% | 2     |

Cause of regressions is unclear, but they're minor enough that it's not worth
the hassle of investigating a rollup.


#### Improvements

ctfe: limit hashing of big const allocations when interning [#98097](https://github.com/rust-lang/rust/pull/98097)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=949a64ab20b9d5d4516416c4735b134e0496855a&end=43c47db0b04627dbd0e16a1e7cad14a4a5a60d3a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -6.6% | -6.6% | 3     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |


Batch proc_macro RPC for TokenStream iteration and combination operations [#98186](https://github.com/rust-lang/rust/pull/98186)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ff86b27e7be1ffff9e00d80beb15560d5f301459&end=0182fd99afaf4a3d602de6b88506edaf6043c125&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -1.0% | -4.0% | 26    |
| Improvements 🎉 <br /> (secondary) | -12.1% | -37.5% | 15    |
| All 😿🎉 (primary) | -1.0% | -4.0% | 26    |


Fix `MissingDoc` quadratic behaviour [#98153](https://github.com/rust-lang/rust/pull/98153)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0182fd99afaf4a3d602de6b88506edaf6043c125&end=cdcc53b7dc002ea4a7a28105010c5a1126ee31b7&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 14    |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.3% | -0.4% | 14    |


Make some lints incremental. [#98238](https://github.com/rust-lang/rust/pull/98238)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=15fc228d0d0a68b5ba565758fab13ed7f863fcea&end=67404f7200c13deec255ffe1146e1d2c9d0d3028&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.4% | -1.7% | 54    |
| Improvements 🎉 <br /> (secondary) | -7.4% | -90.8% | 17    |
| All 😿🎉 (primary) | -0.4% | -1.7% | 54    |


[RFC 2011] Expand expressions where possible [#98148](https://github.com/rust-lang/rust/pull/98148)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=08871139915b95ec868aff807f224f78d00f4311&end=42dcf70f99c21c6d59ad036e33e846769b369fff&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.4% | 2     |
| Improvements 🎉 <br /> (secondary) | -0.7% | -0.8% | 6     |
| All 😿🎉 (primary) | -0.3% | -0.4% | 2     |

Compile `unicode-normalization` faster [#97936](https://github.com/rust-lang/rust/pull/97936)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3bebee73397b692e84b9cc1b6af439fae78918c9&end=cacc75c82ebe15cf63d31034fcf7f1016cddf0e2&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.0% | 1.0% | 1     |
| Improvements 🎉 <br /> (primary) | -14.2% | -19.4% | 6     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -14.2% | -19.4% | 6     |

A solid improvement, though just to the one benchmark; coercions change in the
regressions section is likely just noise, not an actual meaningful delta.

#### Mixed

Use valtrees as the type-system representation for constant values [#96591](https://github.com/rust-lang/rust/pull/96591)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=872503d918b2c3266d828f85e42951df74f5e303&end=1f34da9ec8a85b6f86c5fa1c121ab6f88f2f4966&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.6% | 54    |
| Regressions 😿 <br /> (secondary) | 3.1% | 14.3% | 29    |
| Improvements 🎉 <br /> (primary) | -3.0% | -5.9% | 10    |
| Improvements 🎉 <br /> (secondary) | -1.1% | -1.6% | 7     |
| All 😿🎉 (primary) | -0.2% | -5.9% | 64    |

Large change (over 2000 lines changed) that is a first step for further work on
constant evaluation in the compiler. Overall this is still an improvement, and
regressions are primarily on stress tests. See [this
comment](https://github.com/rust-lang/rust/pull/96591#issuecomment-1156381494)
for some further context.

Split up `Definitions` and `ResolverAstLowering`. [#98106](https://github.com/rust-lang/rust/pull/98106)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ecdd374e6123d79b89c3ecea618d827c931b81cd&end=3a8b0144c82197a70e919ad371d56f82c2282833&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.4% | 0.5% | 9     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.6% | 39    |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.6% | 5     |
| All 😿🎉 (primary) | -0.3% | -0.6% | 39    |


btree: avoid forcing the allocator to be a reference [#98178](https://github.com/rust-lang/rust/pull/98178)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=529c4c71793fbf4305d65b1c4d826a5d0e748fb3&end=ff86b27e7be1ffff9e00d80beb15560d5f301459&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.4% | 0.4% | 1     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -2.0% | -2.0% | 1     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.8% | -2.0% | 2     |
