use test;
use sql;
use core:io;

test Mixed {
	SQLite db;

	// To create tables.
	SimpleDB c(db);

	WITH db {
		INSERT INTO test VALUES (1, "test");
		INSERT INTO test VALUES (2, "test2");

		StrBuf names;
		for (row in SELECT * FROM test) {
			names << row.getStr(1) << "|";
		}

		check names.toS == "test|test2|";
	}
}

test Exclusive {
	SQLite db;

	WITH db: CREATE TABLE test(id INTEGER PRIMARY KEY, name TEXT);
	WITH db: CREATE INDEX ON test(name);

	check db.tables.count == 1;

	WITH db: DROP TABLE test;

	check db.tables.count == 0;
}
