%% mpicpm07-7.m (figure 7.7)
%% mathsPIC    circle with arrows
%%-------------------
\documentclass[a4paper]{article}
\usepackage{mathspic}
\begin{document}
%%---------------------
\beginpicture
paper{units(1mm), xrange(5,55), yrange(5,55)}
point(C){30,30}[symbol=$\odot$,radius=1.2]   %% center
var r = 20                     %% radius
drawcircle(C,r)
point(P){C, polar(r,250 deg)}
point(Q){C, polar(r,120 deg)}
point(S){C, polar(r,-30 deg)}
drawpoint(CPQS)
drawline(PCSQP)
text($P$){P, polar(5,250 deg)}
text($Q$){Q, polar(5,120 deg)}
text($S$){S, polar(5,-30 deg)}
drawAngleArrow{angle(PCS), radius(8) internal anticlockwise}
text($\beta$){C, polar(5,285 deg)}
drawAngleArrow{angle(PQS), radius(12) internal anticlockwise}
text($\alpha$){Q, polar(8,-65 deg)}
showangle(PQS)     % alpha
showangle(PCS)     % beta
\endpicture
%%-------------------
\end{document}
