---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, astronomie, symbole astronomique
---

# Comment obtenir des symboles astronomiques ?

Plusieurs extensions fournissent un certain nombre de ces symboles. Elles
contiennent également des symboles astrologiques, mais pas votre horoscope.

## Avec l'extension <ctanpkg:starfont>

L'extension <ctanpkg:starfont> est dédiée à ce sujet 
et propose plus de 70 symboles (en deux versions avec et sans empattements).


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{starfont}

\begin{document}
Sans empattement : \Sun \Terra \Moon \Aries \Taurus \Gemini \Ceres.

Avec empattement : \starfontserif \Sun \Terra \Moon \Aries \Taurus 
\Gemini \Ceres.
\end{document}
```


## Avec l'extension <ctanpkg:marvosym>

L'extension <ctanpkg:marvosym> met à disposition les symboles du soleil, 
de la lune, des planètes du système solaire et les signes zodiacaux.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{marvosym}

\begin{document}
\Sun \Earth \Moon \Aries \Taurus \Gemini
\end{document}
```


## Avec l'extension <ctanpkg:mathabx>

L'extension <ctanpkg:mathabx> met à disposition des symboles 
utilisables en mode mathématique : ceux du soleil, de la lune (dans plusieurs phases), 
des planètes du système solaire et une partie seulement des signes zodiacaux.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{mathabx}

\begin{document}
$\Sun \Earth \rightmoon \Aries \Taurus \Gemini$
\end{document}
```


## Avec l'extension <ctanpkg:wasysym>

L'extension <ctanpkg:wasysym> met à disposition une trentaine de symboles.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{wasysym}

\begin{document}
\astrosun \earth \rightmoon \aries \taurus \gemini
\end{document}
```


## Avec l'extension <ctanpkg:pifont>

En section 9 de [The Comprehensive LaTeX Symbol List](ctanpkg:comprehensive) 
("la liste complète des symboles de LaTeX") de Scott Pakin *et al.*, 
une technique est présentée pour obtenir certains symboles. 
En passant par l'extension <ctanpkg:pifont>, certains symboles de fontes peuvent être chargés 
(sous réserve de connaître alors leur numéro dans la table de caractère). 
L'exemple suivant donne accès à trois polices de caractères de l'extension <ctanpkg:astro> 
(qu'il faut appeler avec `astrosym`) donnant accès à des symboles astronomiques et astrologiques :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{pifont}

  \DeclareFontFamily{U}{astrosym}{}
  \DeclareFontShape{U}{astrosym}{m}{n}{<-> astrosym}{}

\begin{document}
Première police : \Pisymbol{astrosym}{0} \Pisymbol{astrosym}{29} 
\Pisymbol{astrosym}{41} \Pisymbol{astrosym}{11} \Pisymbol{astrosym}{12}
\Pisymbol{astrosym}{13}  \Pisymbol{astrosym}{48}

Deuxième police : \Pisymbol{astrosym}{100} \Pisymbol{astrosym}{129} 
\Pisymbol{astrosym}{141} \Pisymbol{astrosym}{111} \Pisymbol{astrosym}{112}
\Pisymbol{astrosym}{113}  \Pisymbol{astrosym}{148}

Troisième police : \Pisymbol{astrosym}{200} \Pisymbol{astrosym}{229}
\Pisymbol{astrosym}{241} \Pisymbol{astrosym}{211} \Pisymbol{astrosym}{212}
\Pisymbol{astrosym}{213}  \Pisymbol{astrosym}{248}
\end{document}
```


## Avec les fontes des extensions <ctanpkg:astro> et <ctanpkg:cmastro>

Les deux extensions <ctanpkg:astro> et <ctanpkg:cmastro> mettent à disposition 
des fontes contenant des symboles astronomiques.