#!/bin/sh
THUNDERBIRD_DIR="$1"
DESTDIR="$2"

if ! [ -d "$THUNDERBIRD_DIR"/browser ]; then
	if [ -d "$THUNDERBIRD_DIR"-esr/browser ]; then
		echo
		echo "ERROR: Thunderbird ESR is installed, but THUNDERBIRD_DIR points to"
		echo "       regular Thunderbird."
		echo
		echo "Run this instead:"
		echo "$ make"
		echo "$ sudo make THUNDERBIRD_DIR=$THUNDERBIRD_DIR-esr install"
		echo
		exit 1
	else
		echo
		echo "WARNING: THUNDERBIRD_DIR does not exist: $THUNDERBIRD_DIR"
		echo "This should be fine during packaging. However if you just ran"
		echo "'make install' manually, consider running 'make uninstall', then"
		echo "adjusting THUNDERBIRD_DIR (in the Makefile or via environment"
		echo "variable) and running 'make install' again."
		echo
	fi
fi

if [ -z "$DESTDIR" ] && [ "$(id -u)" != 0 ]; then
	echo
	echo "ERROR: run make install as root!"
	echo
	echo "$ make"
	echo "$ sudo make THUNDERBIRD_DIR=$THUNDERBIRD_DIR install"
	echo
	exit 1
fi
