// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --clang-args ['-target-feature', '+gcs'] --version 2
// RUN: %clang_cc1 -triple aarch64-eabi -target-feature +gcs -emit-llvm %s -o - | FileCheck %s

#include <arm_acle.h>

// CHECK-LABEL: define dso_local i64 @test_chkfeat
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[__FEATURES_ADDR_I:%.*]] = alloca i64, align 8
// CHECK-NEXT:    store i64 1, ptr [[__FEATURES_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[__FEATURES_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = call i64 @llvm.aarch64.chkfeat(i64 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[__FEATURES_ADDR_I]], align 8
// CHECK-NEXT:    [[XOR_I:%.*]] = xor i64 [[TMP1]], [[TMP2]]
// CHECK-NEXT:    ret i64 [[XOR_I]]
//
uint64_t test_chkfeat() {
  return __chkfeat(_CHKFEAT_GCS);
}

// CHECK-LABEL: define dso_local ptr @test_gcspr
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.read_volatile_register.i64(metadata [[META2:![0-9]+]])
// CHECK-NEXT:    [[TMP1:%.*]] = inttoptr i64 [[TMP0]] to ptr
// CHECK-NEXT:    ret ptr [[TMP1]]
//
void *test_gcspr() {
  return __gcspr();
}

// CHECK-LABEL: define dso_local i64 @test_gcspopm
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.aarch64.gcspopm(i64 0)
// CHECK-NEXT:    ret i64 [[TMP0]]
//
uint64_t test_gcspopm() {
  return __gcspopm();
}

// CHECK-LABEL: define dso_local ptr @test_gcsss
// CHECK-SAME: (ptr noundef [[P:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[__STACK_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[__STACK_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[__STACK_ADDR_I]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = call ptr @llvm.aarch64.gcsss(ptr [[TMP1]])
// CHECK-NEXT:    ret ptr [[TMP2]]
//
void *test_gcsss(void *p) {
  return __gcsss(p);
}
